const blogCatRouter = require("express").Router();
const blogCatController = require("../controllers/blogCat.controller");

module.exports = (app) => {
  blogCatRouter.post("/", blogCatController.create);

  // get all

  blogCatRouter.get("/", blogCatController.getAll);

  // get one blog with id

  blogCatRouter.get("/:id", blogCatController.getOne);

  // get active data

  blogCatRouter.get("/getData/active", blogCatController.getActiveData);

  // update

  blogCatRouter.put("/:id", blogCatController.update);

  // delete

  blogCatRouter.delete("/:id", blogCatController.delete);

  app.use("/api/blog-category", blogCatRouter);
};
