const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const { getCampeignDataWithLimit, getAllActiveCampeignData } = require('./getActiveData');

exports.getAllCampeignsByCatId = async (req, res) => {
    try {
        const { cat_id } = req.params;

        const { limit, page } = req.query;

        let result = [];

        if (limit && page) {
            result = await getCampeignDataWithLimit(limit, page, cat_id);
        } else {
            result = await getAllActiveCampeignData(cat_id);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};
