const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');
const { model } = require('../../../../config/database.config');

const { courseRegistration } = model;
const { validatedData } = require('./validationData');

function createCourseRegService(data) {
    try {
        const validData = validatedData(data);
        const result = courseRegistration.create(validData);
        return result;
    } catch (err) {
        throw new Error(err);
    }
}

exports.createCourseReg = async (req, res) => {
    try {
        const data = req.body;
        const createdReg = await createCourseRegService(data);
        if (!createdReg) return errorResponse(400, 'ERROR', 'Course Registration Failed', res);
        return successResponse(201, 'OK', 'Course Registration Successful', res, createdReg);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};
