const courseRegRouter = require('express').Router();
const { createCourseReg } = require('../controllers/courseRegCreate');
const { getRegisteredDataByUser } = require('../controllers/getUserCourseReg');
const { verifyUser } = require('../../../../middlewares/authJwt');

const { getAllCourseReg } = require('../controllers/getAllCourseReg');

module.exports = (app) => {
    courseRegRouter.post('/', createCourseReg);

    // get registered course by user

    courseRegRouter.get('/user', verifyUser, getRegisteredDataByUser);

    // get all course registration

    courseRegRouter.get('/', getAllCourseReg);

    app.use('/api/course-registration', courseRegRouter);
};
