const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const DestinationModel = db.model.destination;
const PackageModel = db.model.package;

exports.create = async (req, res) => {
    try {
        const { country_name, success_count, description,
            country,
            population,
            capital,
            language,
            currency, status } = req.body;
        const { files } = req;

        const country_img = files?.find((file) => file?.fieldname === 'country_img').filename;

        const destinationData = {
            country_name,
            success_count,
            description,
            country_img,
            country,
            population,
            capital,
            language,
            currency,
            status,
        };

        const result = await DestinationModel.create(destinationData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Destination created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await DestinationModel.findAll({
            include: [
                {
                    model: PackageModel,
                    as: 'package',
                    // attributes: ['id', 'name'],
                }
            ],
            order: [['id', 'DESC']],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getOne = async (_, res) => {
    try {
        const { id } = _.params;
        const result = await DestinationModel.findOne({
            where: {
                id,
            },
            include: [
                {
                    model: PackageModel,
                    as: 'package',
                    // attributes: ['id', 'name'],
                }
            ],
            order: [['id', 'DESC']],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await DestinationModel.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: PackageModel,
                    as: 'package',
                    // attributes: ['id', 'name'],
                }
            ],
            order: [['id', 'DESC']],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { country_name, success_count, description,
            country,
            population,
            capital,
            language,
            currency, 
            status } = req.body;
        const { files } = req;

        console.log(req.body);

        const isExist = await DestinationModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const country_img =
            files?.find((file) => file?.fieldname === 'country_img')?.filename ||
            isExist?.country_img;

        const destinationData = {
            country_name,
            country_img,
            success_count,
            description,
            country,
            population,
            capital,
            language,
            currency,
            status,
        };

        const result = await DestinationModel.update(destinationData, {
            where: {
                id,
            },
        });

        console.log("Update: result", result)
        // if (!result.include(1)) {
        //     return errorResponse(404, 'FAILED', 'Destination created failed', res);
        // }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await DestinationModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Destination deleted failed', res);
        }

        return successResponse(204, 'OK', 'Destination deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
