/* eslint-disable no-unused-vars */
const db = require('../../../../config/database.config');

// const Package = db.model.package;
const Facility = db.model.facility;

const { PackageCategory } = db.model;
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

exports.create = async (req, res) => {
    const facilityData = req.body;
    console.log(facilityData);

    const { name, image, description } = facilityData;
    //   res.json(facilityData);
    try {
        const newFacility = await Facility.create({
            name,
            image,
            description,
        });

        if (!newFacility) {
            return errorResponse(500, 'ERROR', 'Package not created', res);
        }

        // const { id } = newFacility;
        // if (features.length > 0) {
        //     await Promise.all(
        //         features.map(async (feature) => {
        //             await PackageFeature.create({
        //                 package_id: id,
        //                 name: feature.name,
        //                 value: feature.value,
        //             });
        //         })
        //     );
        // }
        successResponse(200, 'OK', newFacility, res);
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getAll = async (req, res) => {
    try {
        const packages = await Package.findAll();
        if (packages) {
            successResponse(200, 'OK', packages, res);
        }
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.delete = (req, res) => {
    const { id } = req.params;

    Package.destroy({
        where: { id },
    })
        .then((num) => {
            if (num == 1) {
                PackageFeature.destroy({
                    where: {
                        package_id: id,
                    },
                })
                    .then((num) => {
                        res.send({
                            message: 'Package was deleted successfully!',
                        });
                    })
                    .catch((err) => {
                        res.status(500).send({
                            message: `Could not delete Package with id=${id}`,
                        });
                    });
            } else {
                res.send({
                    message: `Cannot delete Package with id=${id}. Maybe Package was not found!`,
                });
            }
        })
        .catch((err) => {
            res.status(500).send({
                message: `Could not delete Package with id=${id}`,
            });
        });
};

exports.update = async (req, res) => {
    const { id } = req.params;
    const { name, image, description } = req.body;
    console.log(req.body);

    try {
        const isExist = await Package.findByPk(id);

        if (!isExist) {
            return errorResponse(400, 'ERROR', 'Package Not Found!', res);
        }

        const updatedPackage = await Package.update(
            {
                name,
                image,
                description,
            },
            {
                where: {
                    id,
                },
            }
        );
        console.log(updatedPackage);

        if (!updatedPackage.includes(1)) {
            return errorResponse(400, 'ERROR', 'Package Update Failed!', res);
        }

        await PackageFeature.destroy({
            where: {
                package_id: id,
            },
        });

        if (features.length > 0) {
            await Promise.all(
                features.map(async (feature) => {
                    await PackageFeature.create({
                        package_id: id,
                        name: feature.name,
                        value: feature.value,
                    });
                })
            );
        }
        return successResponse(200, 'OK', 'Package Updated Successfully!', res);
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getById = async (req, res) => {
    const { id } = req.params;
    try {
        const facilityData = await Package.findOne({
            where: {
                id,
            },
            include: [
                {
                    model: PackageCategory,
                    as: 'packageCat',
                    attributes: ['name'],
                },
                {
                    model: PackageFeature,
                    order: [['id', 'ASC']],
                    separate: true,
                },
            ],
        });
        successResponse(200, 'OK', facilityData, res);
    } catch (e) {
        errorResponse(500, 'ERROR', e.message || 'Some error occurred while Creating Package', res);
    }
};

exports.getPacByCatId = async (req, res) => {
    const { id } = req.params;
    try {
        const facilityData = await Package.findAll({
            where: {
                package_cat_id: id,
            },
            include: [
                {
                    model: PackageFeature,
                    order: [['id', 'ASC']],
                    separate: true,
                },
                {
                    model: PackageCategory,
                    as: 'packageCat',
                    attributes: ['name'],
                },
            ],
            order: [['id', 'DESC']],
        });
        successResponse(200, 'OK', facilityData, res);
    } catch (e) {
        errorResponse(500, 'ERROR', e.message || 'Some error occurred while Creating Package', res);
    }
};
