const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const JobListModel = db.model.job_list;
const Gender = db.model.gender;
const Country = db.model.country;
const JobRequestModel = db.model.job_request;

exports.create = async (req, res) => {
    try {
        const {
            gender,

            title,

            company_name,

            job_type,

            category,

            job_tag,

            location,

            offered_salary,

            ctc,

            experience,

            industry,

            application_end,

            job_description,

            status,
        } = req.body;

        const { files } = req;

        const jobData = {
            gender,
            title,

            job_img: files?.find((file) => file?.fieldname === 'job_img')?.filename || null,
            company_name,
            job_type,
            category,
            job_tag,
            location,
            offered_salary,
            ctc,
            experience,
            industry,
            application_end,
            job_description,
            status,
        };

        const result = await JobListModel.create(jobData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Failed to create job list', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

exports.getAll = async (_, res) => {
    try {
        const result = await JobListModel.findAll({
            include: [
                {
                    model: Gender,
                    as: 'genderInfo',
                },
                {
                    model: Country,
                    as: 'locationInfo',
                },
            ],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await JobListModel.findOne({
            where: {
                id,
            },
            include: [
                {
                    model: Gender,
                    as: 'genderInfo',
                },
                {
                    model: Country,
                    as: 'locationInfo',
                },
            ],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

exports.getActiveData = async (req, res) => {
    try {
        const { location } = req.query;
        console.log(location);

        const whereClouse = {
            status: 1,
        };

        if (location) {
            whereClouse.location = location;
        }

        console.log('l', whereClouse);

        const result = await JobListModel.findAll({
            where: whereClouse,
            include: [
                {
                    model: Gender,
                    as: 'genderInfo',
                },
                {
                    model: Country,
                    as: 'locationInfo',
                },
            ],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// job request data for job

exports.getJobRequestData = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await JobListModel.findOne({
            where: {
                id,
            },
            include: [
                {
                    model: Gender,
                    as: 'genderInfo',
                },
                {
                    model: Country,
                    as: 'locationInfo',
                },
                {
                    model: JobRequestModel,
                },
            ],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

exports.getLocationOfAllJobs = async (_, res) => {
    try {
        const result = await JobListModel.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: Country,
                    as: 'locationInfo',
                },
            ],
            attributes: ['location'],
            group: ['location'],
        });

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;

        const isExist = await JobListModel.findByPk(id);

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No data found with this id', res);
        }
        const {
            gender,

            title,
            company_name,

            job_type,

            category,

            job_tag,

            location,

            offered_salary,

            ctc,

            experience,

            industry,

            application_end,

            job_description,

            status,
        } = req.body;

        const { files } = req;

        console.log(files);

        const jobData = {
            gender,
            title,

            job_img:
                files?.find((file) => file?.fieldname === 'job_img')?.filename || isExist?.job_img,
            company_name,
            job_type,
            category,
            job_tag,
            location,
            offered_salary,
            ctc,
            experience,
            industry,
            application_end,
            job_description,
            status,
        };

        const result = await JobListModel.update(jobData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Failed to update new Banner', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete heroSection

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await JobListModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Hero section modal deleted failed', res);
        }

        return successResponse(204, 'OK', 'Hero section deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
