const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

// dbs

const { mosque_list: MosqueList } = db.model;

exports.create = async (req, res) => {
    try {
        const { name, address, masjid_id, order, status } = req.body;

        const result = await MosqueList.create({
            name,
            address,
            masjid_id,
            order,
            status,
        });

        if (!result) {
            return errorResponse(404, 'FAILED', 'Salat times create Failed', res);
        }
        return successResponse(201, 'OK', result, res);
    } catch (err) {
        console.log(err);
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};
