const newsletterSubscriptionRouter = require('express').Router();
const newsletterSubscriptionController = require('../controllers/newsletterSubscription.controller');

module.exports = (app) => {
    newsletterSubscriptionRouter.post('/', newsletterSubscriptionController.create);

    // get all the data

    newsletterSubscriptionRouter.get('/', newsletterSubscriptionController.getAll);

    // get active data

    newsletterSubscriptionRouter.get('/getData/active', newsletterSubscriptionController.getActiveData);

    // get one data

    newsletterSubscriptionRouter.get('/:id', newsletterSubscriptionController.getOne);

    // update hero hero-section

    newsletterSubscriptionRouter.put('/:id', newsletterSubscriptionController.update);

    // delete hero section
    newsletterSubscriptionRouter.delete('/:id', newsletterSubscriptionController.delete);

    app.use('/api/newsletterSubscription', newsletterSubscriptionRouter);
};
