const packageRouter = require('express').Router();
const packageController = require('../controllers/package.controller');
const activePackage = require('../controllers/activePackage.controller');
const { verifyToken } = require('../../../../middlewares/authJwt');
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');

module.exports = (app) => {
    // create package
    packageRouter.post('/', websiteImageUpload, packageController.create);

    // fetch all package
    packageRouter.get('/', packageController.getAll);
    
    // fetch all package
    packageRouter.get('/packages', packageController.getAllActive);
    // update package
    packageRouter.put('/:id', websiteImageUpload, packageController.update);

    // get package by id
    packageRouter.get('/:id', packageController.getById);
    
    // get active
    packageRouter.get('/data/active', activePackage.getActivePackage);
    
    // get one active package
    packageRouter.get('/data/active/:id', verifyToken, activePackage.getOneActivePackage);
    
    // get all the package by package category id
    
    // packageRouter.get('/category/:id', packageController.getPacByCatId);
    
    // delete package
    packageRouter.delete('/:id', packageController.delete);

    //search package
    packageRouter.get('/search/packages', packageController.searchPackage );


    app.use('/api/package-management', packageRouter);
};
