const { Op } = require('sequelize');
const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

const StaticContent = db.model.staticContent;
const StaticContentGroup = db.model.staticContentGroup;
const PackageModel = db.model.package;
const campeignsModel = db.model.campeigns;

exports.getPaymentPackageWithCategories = async (req, res) => {
    try {
        const packageData = await StaticContent.findAll({
            include: [
                {
                    model: StaticContentGroup,
                    attributes: [],
                    where: {
                        name: {
                            [Op.like]: 'payment',
                        },
                    },
                },
            ],
        });

        const AllPackageData = await PackageModel.findAll();

        const AllCampeignsData = await campeignsModel.findAll();

        const result = packageData?.map((item) => ({
            ...item.dataValues,
            sub_category:
                item.id === 27 ? AllPackageData : item.id === 28 ? AllCampeignsData : null,
        }));

        console.log(packageData);

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while geting payment package',
            res
        );
    }
};
