const paymentRoute = require('express').Router();
const paymentPackage = require('../controllers/paymentPackage');
const paypalPayment = require('../controllers/paypalPayment');
const { verifyToken } = require('../../../../middlewares/authJwt');
const donationPayment = require('../controllers/donationPayment');
const { createPaypalOrderId } = require('../controllers/createPaypalOrderId');
const { getUserPaymentData } = require('../controllers/getUserPaymentData');
const {
    createStripePaymentOrder,
    paymentStatusCheckAndSave,
    createStripeDonationIntent,
} = require('../controllers/stripePayment');

const { stripeWebHooks } = require('../controllers/stripeWebHook');

module.exports = (app) => {
    paymentRoute.get('/payment-packages', paymentPackage.getPaymentPackageWithCategories);
    paymentRoute.post('/paypal/create-order', createPaypalOrderId);
    // capture payment

    paymentRoute.post(
        '/paypal/capture-payment',
        verifyToken,
        paypalPayment.capturePackagePaymentWithPaypal
    );

    // donation capture paypal

    paymentRoute.post(
        '/donation/paypal/capture-payment',
        verifyToken,
        donationPayment.captureDonationPayment
    );

    // get all payment data

    paymentRoute.get('/user-payment-data', verifyToken, getUserPaymentData);

    // stripe pakage payment

    paymentRoute.post('/stripe/package-payment', createStripePaymentOrder);

    paymentRoute.get('/stripe/payment-status', paymentStatusCheckAndSave);

    // donation intent and client secret made

    paymentRoute.post('/stripe/donation/intent', createStripeDonationIntent);

    // stripe web hook

    paymentRoute.post('/stripe/webhook', stripeWebHooks);

    app.use('/api/payment', paymentRoute);
};
