const welcome_message_Router = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const welcome_message_controller = require('../controller/welcome_message.controller');

module.exports = (app) => {
    welcome_message_Router.post('/', welcome_message_controller.create);

    // get all

    welcome_message_Router.get('/', welcome_message_controller.getAll);

    // get active data

    welcome_message_Router.get('/active', welcome_message_controller.getActiveData);

    // get one

    welcome_message_Router.get('/:id', welcome_message_controller.getOne);


    // update

    welcome_message_Router.put('/:id', websiteImageUpload, welcome_message_controller.update);

    // delete

    welcome_message_Router.delete('/:id', welcome_message_controller.delete);

    app.use('/api/welcome_messages', welcome_message_Router);
};
